#pragma once

#include <internal/services/http_client_config.h>

namespace sharpei::services::iam {

struct IamClientConfig {
    HttpClientConfig http;
};

struct IamPollerConfig {
    std::size_t coroutineStackSize;
    std::chrono::seconds minAllowedInterval;
    std::chrono::seconds minInterval;
    std::chrono::seconds maxInterval;
};

struct IamConfig {
    IamClientConfig client;
    IamPollerConfig poller;
    std::string jwtFilePath;
};

} // namespace sharpei::services::iam
