#pragma once

#include <internal/services/iam/iam_client.h>
#include <internal/services/iam/iam_config.h>
#include <internal/services/iam/iam_token_cache.h>
#include <internal/random_interval_generator.h>

namespace sharpei::services::iam {

class IamPoller : public std::enable_shared_from_this<IamPoller> {
public:
    IamPoller(std::string uniqId, const IamPollerConfig& config, IamPtr client, IamTokenCachePtr iamTokenCache)
        : uniqId(std::move(uniqId)), config(config), client(client), iamTokenCache(iamTokenCache),
          intervalGenerator(config.minInterval, config.maxInterval, config.minAllowedInterval) {}

    void start(boost::asio::io_context& io);
    void stop();

private:
    std::string uniqId;
    IamPollerConfig config;
    IamPtr client;
    IamTokenCachePtr iamTokenCache;
    RandomIntervalGenerator intervalGenerator;
    std::atomic_bool shouldStop {};
};

} // namespace sharpei::services::iam
