#pragma once

#include <internal/expected.h>
#include <internal/task_context.h>

#include <string>
#include <memory>

namespace sharpei::services::iam {

struct JsonWebTokenGenerator {
    virtual ~JsonWebTokenGenerator() = default;
    virtual expected<std::string> generate(const TaskContextPtr& context) const = 0;
};

using JsonWebTokenGeneratorPtr = std::shared_ptr<const JsonWebTokenGenerator>;

} // namespace sharpei::services::iam
