#pragma once

#include <internal/services/types.h>
#include <internal/config.h>
#include <internal/expected.h>

#include <io_result/bind.h>

#include <ymod_httpclient/call.h>

#include <ymod_tvm/module.h>

#include <yplatform/find.h>

namespace sharpei::services {

inline std::shared_ptr<ymod_httpclient::cluster_call> getHttpClient(const std::string& module) {
    return yplatform::find<ymod_httpclient::cluster_call, std::shared_ptr>(module);
}

inline std::shared_ptr<ymod_tvm::tvm2_module> getTvm2(const std::string& module) {
    return yplatform::find<ymod_tvm::tvm2_module, std::shared_ptr>(module);
}

} // namespace sharpei::services
