#pragma once

#include <internal/expected.h>
#include <internal/task_context.h>

#include <boost/serialization/strong_typedef.hpp>

namespace sharpei::services::yc {

BOOST_STRONG_TYPEDEF(std::string_view, IamToken);

struct Host {
    std::string name;
    std::string zoneId;
};

struct Yc {
    virtual ~Yc() = default;

    virtual expected<std::vector<Host>> getHosts(const IamToken& iamToken, const TaskContextPtr& context) const = 0;
};

using YcPtr = std::shared_ptr<const Yc>;

} // namespace sharpei::services::yc
