#pragma once

#include <internal/services/yc/yc.h>
#include <internal/services/yc/yc_config.h>

#include <ymod_httpclient/call.h>

namespace sharpei::services::yc {

class YcClient final : public Yc {
public:
    YcClient(const YcClientConfig& config, std::shared_ptr<ymod_httpclient::cluster_call> httpClient)
        : config(config), httpClient(httpClient) {}

    expected<std::vector<Host>> getHosts(const IamToken& iamToken, const TaskContextPtr& context) const override;

private:
    YcClientConfig config;
    std::shared_ptr<ymod_httpclient::cluster_call> httpClient;
};

} // namespace sharpei::services::yc
