#pragma once

#include <internal/services/yc/yc_client.h>
#include <internal/services/yc/yc_config.h>
#include <internal/services/yc/yc_hosts_cache.h>
#include <internal/services/iam/iam_token_cache.h>

#include <optional>
#include <future>

namespace sharpei::services::yc {

class YcPoller : public std::enable_shared_from_this<YcPoller> {
public:
    YcPoller(std::string uniqId, const YcPollerConfig& config, YcPtr client,
             iam::IamTokenCachePtr iamTokenCache, YcHostsCachePtr hostsCache)
        : uniqId(std::move(uniqId)),
          config(config),
          client(client),
          iamTokenCache(iamTokenCache),
          hostsCache(hostsCache) {}

    void start(boost::asio::io_context& io);
    void stop();

private:
    std::string uniqId;
    YcPollerConfig config;
    YcPtr client;
    iam::IamTokenCachePtr iamTokenCache;
    YcHostsCachePtr hostsCache;
    std::optional<std::future<void>> writeFsHostsCacheResult;
    std::atomic_bool shouldStop {};

    void asyncWriteFsHostsCache(const TaskContextPtr& context);
};

} // namespace sharpei::services::yc
