#pragma once

#include <internal/logger.h>
#include <yplatform/task_context.h>
#include <boost/asio/spawn.hpp>

namespace sharpei {

class TaskContext : public yplatform::task_context {
public:
    TaskContext(const std::string& uniqId, const std::string& requestId, boost::asio::yield_context yield)
        : yplatform::task_context(uniqId),
          requestId_(requestId),
          yield_(yield),
          scribe_(uniqId, requestId) {
    }

    const std::string& requestId() const {
        return requestId_;
    }

    const boost::asio::yield_context& yield() const {
        return yield_;
    }

    const Scribe& scribe() const {
        return scribe_;
    }

private:
    std::string requestId_;
    boost::asio::yield_context yield_;
    Scribe scribe_;
};

using TaskContextPtr = boost::shared_ptr<TaskContext>;

inline TaskContextPtr makeTaskContext(const std::string& uniqId, const std::string& requestId,
        boost::asio::yield_context yield) {
    return boost::make_shared<TaskContext>(uniqId, requestId, yield);
}

} // namespace sharpei
