#pragma once

#include <yplatform/reactor.h>

#include <boost/asio/executor_work_guard.hpp>
#include <boost/asio/io_context.hpp>

#include <memory>
#include <string>
#include <thread>

namespace sharpei {

class IoThreadWorker {
public:
    IoThreadWorker(std::string uniqId, boost::asio::io_context& io);
    ~IoThreadWorker();

    void stop();

private:
    std::string uniqId;
    boost::asio::io_context* io;
    boost::asio::executor_work_guard<boost::asio::io_context::executor_type> work;
    std::thread thread;

    void serve();
};

class ThreadPool {
public:
    ThreadPool(unsigned workers) {
        reactor.init(/* pool_count */ 1, workers);
    }

    void start() {
        reactor.run();
    }

    void stop() {
        reactor.stop();
    }

    boost::asio::io_service& io() {
        return *reactor.io();
    }

private:
    yplatform::reactor reactor;
};

} // namespace sharpei
