#ifndef SHARPEI_USER_H
#define SHARPEI_USER_H

#include <string>

namespace sharpei {

template <class T>
class BasicUserId {};

template <>
class BasicUserId<std::int64_t> {
public:
    using Value = std::int64_t;

    BasicUserId(Value value = Value())
            : value_(value) {
    }

    Value value() const {
        return value_;
    }

private:
    Value value_;
};

template <>
class BasicUserId<std::string> {
public:
    using Value = std::string;

    BasicUserId(Value value = Value())
            : value_(std::move(value)) {
    }

    const Value& value() const {
        return value_;
    }

private:
    Value value_;
};

template <class T>
inline bool operator ==(const BasicUserId<T>& lhs, const BasicUserId<T>& rhs) {
    return lhs.value() == rhs.value();
}

inline std::string to_string(sharpei::BasicUserId<std::int64_t> value) {
    return std::to_string(value.value());
}

inline const std::string& to_string(const sharpei::BasicUserId<std::string>& value) {
    return value.value();
}

} // namespace std

#endif // SHARPEI_USER_H
