#pragma once

#include <random>
#include <vector>
#include <boost/range/numeric.hpp>
#include <boost/range/adaptor/map.hpp>

namespace sharpei {

template <class RandomAccessIteratorRange, class Generator>
auto getRandomByWeight(const RandomAccessIteratorRange& range, Generator& generator) {
    using boost::adaptors::map_values;
    using Weight = typename RandomAccessIteratorRange::value_type::second_type;

    const auto size = boost::distance(range);
    if (size <= 0) {
        return std::end(range);
    }
    std::vector<Weight> weightsPartialSum;
    weightsPartialSum.reserve(std::size_t(size));
    boost::partial_sum(range | map_values, std::back_inserter(weightsPartialSum));
    if (weightsPartialSum.back() == 0) {
        return std::end(range);
    }
    const auto randomWeight = std::uniform_int_distribution<Weight>(Weight(0), weightsPartialSum.back() - 1)(generator);
    const auto it = std::lower_bound(weightsPartialSum.begin(), weightsPartialSum.end(), randomWeight,
        [] (auto weight, auto randomWeight) { return weight <= randomWeight; });
    return std::begin(range) + (it - weightsPartialSum.begin());
}

} // namespace sharpei
