#pragma once

#include <algorithm>
#include <cmath>
#include <random>
#include <vector>

namespace sharpei {

template <class RandomAccessIterator, class Generator>
std::vector<std::size_t> weightedShuffle(RandomAccessIterator begin, RandomAccessIterator end, Generator& generator) {
    const auto size = std::distance(begin, end);
    std::vector<double> priorities(size);
    std::uniform_real_distribution<> distribution(0, 1);
    const auto getRandomPriority = [&] (double weight) {
        return weight ? std::copysign(std::pow(distribution(generator), 1.0 / std::abs(weight)), - weight) : 0.0;
    };
    std::transform(begin, end, priorities.begin(), [&] (const auto& v) { return getRandomPriority(v.second); });
    std::vector<std::size_t> result(size);
    std::iota(result.begin(), result.end(), 0);
    std::sort(result.begin(), result.end(), [&] (auto lhs, auto rhs) { return priorities[lhs] < priorities[rhs]; });
    return result;
}

} // namespace sharpei
