package main

import (
	"fmt"
	"net/http"
	"strings"
	"time"
)

func (g *Gun) makeReq(payload *Payload) *http.Request {
	req, _ := http.NewRequest(payload.Method, strings.Join([]string{"http://", g.conf.Target, payload.URI}, ""), strings.NewReader(""))
	req.Header.Add("Content-Type", payload.Cotype)
	req.Header.Add("X-Real-IP", "213.180.206.57")
	req.Header.Add("User-Agent", "pandora")
	return req
}

func (g *Gun) genPayload(ammo *Ammo) *Payload {
	payload := Payload{
		Method: "GET",
		Assert: "error",
		Cotype: "text/plain",
	}
	switch ammo.Tag {
	case "conninfo_all":
		payload.URI = fmt.Sprintf("/conninfo?uid=%s&mode=all", ammo.UID)
	case "conninfo_read":
		payload.URI = fmt.Sprintf("/conninfo?uid=%s&mode=read_only", ammo.UID)
	case "conninfo_write":
		payload.URI = fmt.Sprintf("/conninfo?uid=%s&mode=write_only", ammo.UID)
	case "conninfo_force":
		payload.URI = fmt.Sprintf("/conninfo?uid=%s&mode=all&force", ammo.UID)
	case "registration_conninfo":
		payload.URI = fmt.Sprintf("/conninfo?uid=%d&mode=all", time.Now().UnixNano())
	case "stat_v1":
		payload.URI = "/stat"
	case "stat_v2":
		payload.URI = "/v2/stat"
	case "stat_v3":
		payload.URI = "/v3/stat"
	default:
		payload.URI = "/ping"
	}
	return &payload
}
