die () {
        echo "$1; $2"
        exit 0
}

while getopts "v:w:c:" OPTION
do
    case $OPTION in
        v)
            VOLUME="$OPTARG"
        ;;
        w)
            WARN_LIMIT="$OPTARG"
        ;;
        c)
            CRIT_LIMIT="$OPTARG"
        ;;
    esac
done

volume_name=$VOLUME
warn_limit=${WARN_LIMIT:-80}
crit_limit=${CRIT_LIMIT:-90}

if [ "$volume_name" = "" ]; then
    echo "volume wasn't specified"
    exit 1
fi

used_percent=$(df -h $volume_name | tail -n -1 | awk '{print $5}' | sed 's/%//')

if [ "$used_percent" -ge "$crit_limit" ]; then
    die 2 "$volume_name usage $used_percent%"
elif [ "$used_percent" -ge "$warn_limit" ]; then
    die 1 "$volume_name usage $used_percent%"
else
    die 0 "OK"
fi
