#!/usr/bin/env python3
import psycopg2
import requests


def get_master_host():
    resp = requests.get("http://localhost/sharddb_stat")
    dbs = resp.json()
    master_hosts = [
        instance["address"]["host"] for instance in dbs if instance["role"] == "master"
    ]
    assert len(master_hosts) == 1, "There must be one master host"
    return master_hosts[0]


def get_password():
    with open("/etc/sharpei/.pgpass", "r") as pgpass_file:
        pgpass = pgpass_file.read()
        return pgpass.split(":")[-1]


def main():
    conn = psycopg2.connect(
        sslmode="verify-full",
        user="sharpei",
        password=get_password(),
        sslrootcert="/etc/sharpei/pg_root.crt",
        dbname="sharddb",
        connect_timeout="1",
        host=get_master_host(),
        port="6432",
    )
    conn.set_isolation_level(psycopg2.extensions.ISOLATION_LEVEL_AUTOCOMMIT)
    cur = conn.cursor()
    cur.execute(
        "SELECT gid FROM pg_prepared_xacts WHERE prepared < now() - INTERVAL '1 minutes'"
    )
    for (xact_gid,) in cur.fetchall():
        if "reg_sharddb_u" in xact_gid:
            cur.execute("ROLLBACK PREPARED %s;", (xact_gid,))
    cur.close()
    conn.close()


if __name__ == "__main__":
    main()
