#!/usr/bin/env python3

import os
import subprocess
import sys


def main():
    config = sys.stdin.read()
    config = config.replace("{{ server_name }}", get_ipv6())
    print(config)


def get_ipv6():
    command = "host $(uname -n)"
    p = subprocess.Popen(
        command, shell=True, stdout=subprocess.PIPE, stderr=subprocess.PIPE
    )
    out, err = p.communicate()
    out = out.decode()
    assert not err, "unable to determine my ip address: %s" % err
    assert "has IPv6 address" in out, "unexpected output from the 'host' utility: %s" % output
    ip = out.rsplit(" ", 1)[1]
    if ip[-1] == "\n":
        ip = ip[:-1]
    return ip


if __name__ == "__main__":
    main()
