#!/bin/bash

ENVIRONMENT_TYPE=$(cat /etc/yandex/environment.type)

if [[ -f /etc/push-client/push-client-sharpei-${ENVIRONMENT_TYPE} ]]; then

    mkdir -p /ephemeral/var/lib/push-client/
    chown -R statbox:statbox /ephemeral/var/lib/push-client/
    rsync -av /var/lib/push-client/ /ephemeral/var/lib/push-client/
    rm -rf /var/lib/push-client
    ln -sf /ephemeral/var/lib/push-client /var/lib/push-client

    # export the DAEMON_CONF variable
    . /etc/push-client/push-client-sharpei-${ENVIRONMENT_TYPE}

    DAEMON_OPTS="-f -w "

    for conf in $DAEMON_CONF; do
        DAEMON_OPTS="$DAEMON_OPTS -c $conf "
    done

    /usr/bin/push-client ${DAEMON_OPTS}
else
    echo "config file wasn't found"
fi
