#!/bin/bash -e

if [[ -d /ephemeral ]]; then
    mkdir -p /ephemeral/var/log/
    rsync -av /var/log/ /ephemeral/var/log/

    rm -rf /var/log

    ln -sf /ephemeral/var/log /var/log

    break
else
    echo "Failed to link ephemeral, cannot start"
    exit 1
fi

if [[ -f "${PGPASS_PATH}" ]]; then
    echo "copying pgpass"
    cp -f "${PGPASS_PATH}" /etc/sharpei/.pgpass

    echo "chowning pgpass"
    chown sharpei:sharpei /etc/sharpei/.pgpass

    break
else
    echo "No pgpass found, cannot start"
    exit 1
fi

if [[ -f "${PGCRT_PATH}" ]]; then
    echo "copying pg_root.crt"
    cp -f "${PGCRT_PATH}" /etc/sharpei/pg_root.crt

    echo "chowning pg_root.crt"
    chown sharpei:sharpei /etc/sharpei/pg_root.crt

    break
else
    echo "No pg_root.crt found, cannot start"
    exit 1
fi

if [[ -f "${TVM_SECRET_PATH}" ]]; then
    echo "copying tvm secret"
    cp -f "${TVM_SECRET_PATH}" /etc/sharpei/tvm_secret
    echo "chowning tvm secret"
    chown sharpei:sharpei /etc/sharpei/tvm_secret
    break
else
    echo "No tvm secret found, cannot start"
    exit 1
fi

if [[ -d "${SSL_CERT_KEY_PATH}" ]]; then
    echo "copying ssl cert"
    cp -f "${SSL_CERT_KEY_PATH}"/cert.pem /etc/sharpei/cert.pem
    echo "chowning ssl cert"
    chown sharpei:sharpei /etc/sharpei/cert.pem
    echo "copying ssl key"
    cp -f "${SSL_CERT_KEY_PATH}"/key.pem /etc/sharpei/key.pem
    echo "chowning ssl key"
    chown sharpei:sharpei /etc/sharpei/key.pem
    break
else
    echo "No ssl files found"
fi

CONFIGURATION="mail"
ENVIRONMENT="${CONFIGURATION}-nanny"

function extend_environment {
    if [[ "${ENVIRONMENT}" ]]; then
        ENVIRONMENT="${ENVIRONMENT}-${1}"
    else
        ENVIRONMENT="${1}"
    fi
}

mkdir -p /etc/yandex

if [[ "${ENVIRONMENT_NAME}" ]]; then
    extend_environment "${ENVIRONMENT_NAME}"
    echo "${ENVIRONMENT_NAME}" > /etc/yandex/environment.name
fi

if [[ "${ENVIRONMENT_TYPE}" ]]; then
    extend_environment "${ENVIRONMENT_TYPE}"
    echo "${ENVIRONMENT_TYPE}" > /etc/yandex/environment.type
fi

if ! [[ -f /etc/sharpei/config-${ENVIRONMENT}.yml ]]; then
    echo "sharpei config is not found: /etc/sharpei/config-${ENVIRONMENT}.yml"
    exit 1
fi

ln -sf /etc/sharpei/config-${ENVIRONMENT}.yml /etc/sharpei/config.yml

source /usr/lib/qloud-functions.sh
monrun_prepare

/usr/bin/supervisord -n -c /etc/supervisor/supervisord.conf
