#!/bin/bash -e

for i in {1..10}; do
    if [[ -d /ephemeral ]]; then
        mkdir -p /ephemeral/var/log/
        rsync -av /var/log/ /ephemeral/var/log/

        rm -rf /var/log

        ln -sf /ephemeral/var/log /var/log

        break
    else
        echo "Ephemeral not found, sleeping"
        sleep 5
    fi
done

if [[ "$i" -eq 10 ]]; then
    echo "Failed to link ephemeral, cannot start"
    exit 1
fi

for i in {1..10}; do
    if [[ -f /secrets/jwt_key.json ]]; then
        echo "copying jwt key"
        cp -f /secrets/jwt_key.json /etc/sharpei/jwt_key.json

        echo "chowning jwt key"
        chown sharpei:sharpei /etc/sharpei/jwt_key.json

        break
    else
        echo "No jwt key found, sleeping"
        sleep 5
    fi
done

for i in {1..10}; do
    if [[ -f /secrets/.pgpass ]]; then
        echo "copying pgpass"
        cp -f /secrets/.pgpass /etc/sharpei/.pgpass

        echo "chowning pgpass"
        chown sharpei:sharpei /etc/sharpei/.pgpass

        break
    else
        echo "No pgpass found, sleeping"
        sleep 5
    fi
done

if ! [[ "${CONFIGURATION}" ]]; then
    echo "CONFIGURATION is not set, cannot start"
    exit 1
fi

SUFFIX="${CONFIGURATION}"
ENVIRONMENT=

function extend_suffix {
    if [[ "${SUFFIX}" ]]; then
        SUFFIX="${SUFFIX}-${1}"
    else
        SUFFIX="${1}"
    fi
}

function extend_environment {
    if [[ "${ENVIRONMENT}" ]]; then
        ENVIRONMENT="${ENVIRONMENT}-${1}"
    else
        ENVIRONMENT="${1}"
    fi
}

mkdir -p /etc/yandex

if [[ "${ENVIRONMENT_NAME}" ]]; then
    extend_environment "${ENVIRONMENT_NAME}"
    echo "${ENVIRONMENT_NAME}" > /etc/yandex/environment.name
fi

if [[ "${ENVIRONMENT_TYPE}" ]]; then
    extend_environment "${ENVIRONMENT_TYPE}"
    echo "${ENVIRONMENT_TYPE}" > /etc/yandex/environment.type
fi

if [[ "${ENVIRONMENT}" ]]; then
    extend_suffix "${ENVIRONMENT}"
fi

if ! [[ -f /etc/nginx/sites-available/sharpei-${SUFFIX}.conf.template ]]; then
    echo "sharpei site template config is not found: /etc/nginx/sites-available/sharpei-${SUFFIX}.conf.template"
    exit 1
fi

if ! [[ -f /etc/sharpei/config-${SUFFIX}.yml ]]; then
    echo "sharpei config is not found: /etc/sharpei/config-${SUFFIX}.yml"
    exit 1
fi

/usr/bin/sharpei_gen_jwt /var/run/sharpei/jwt < /etc/sharpei/jwt_key.json

chown sharpei:sharpei /var/run/sharpei/jwt
chmod 600 /var/run/sharpei/jwt

/opt/gen_nginx_site_conf.py < /etc/nginx/sites-available/sharpei-${SUFFIX}.conf.template > /etc/nginx/sites-available/sharpei-${SUFFIX}.conf

ln -sf /etc/sharpei/config-${SUFFIX}.yml /etc/sharpei/config.yml
ln -sf /etc/nginx/sites-available/sharpei-${SUFFIX}.conf /etc/nginx/sites-enabled/sharpei-${SUFFIX}.conf
