#include <internal/cache/shard_name.h>

namespace sharpei {
namespace cache {

ShardNameCache::OptShardName ShardNameCache::get(Shard::Id shardId) const {
    const auto locked = shards.shared_lock();
    const auto shard = locked->find(shardId);
    if (shard == locked->end()) {
        return ShardNameCache::OptShardName();
    }
    return shard->second;
}

void ShardNameCache::update(Shard::Id shardId, Shard::Name name) {
    const auto locked = shards.unique_lock();
    std::swap((*locked)[shardId], name);
}

void ShardNameCache::erase(Shard::Id shardId) {
    shards.unique_lock()->erase(shardId);
}

ShardNameCache::Shards ShardNameCache::all() const {
    return *shards.shared_lock();
}

} // namespace cache
} // namespace sharpei
