#include <internal/cloud/cluster_shards_provider.h>
#include <internal/reflection/shard.h>
#include <internal/errors.h>

#include <boost/range/algorithm/transform.hpp>

namespace sharpei::cloud {
namespace {

using services::yc::Host;

ShardWithoutRoles::Addresses makeAddresses(std::vector<Host> hosts, unsigned port, std::string dbname) {
    using Address = Shard::Database::Address;

    ShardWithoutRoles::Addresses result;
    boost::transform(hosts, std::inserter(result, result.end()), [&] (auto& host) {
        return Address(std::move(host.name), port, dbname, std::move(host.zoneId));
    });
    return result;
}

ShardWithoutRoles makeShardWithoutRoles(std::vector<Host> hosts, unsigned port, std::string dbname) {
    return ShardWithoutRoles(Shard::Id(1), Shard::Name("yc"), makeAddresses(std::move(hosts), port, std::move(dbname)));
}

} // namespace

expected<std::vector<ShardWithoutRoles>> ClusterShardsProvider::getAllShards(const TaskContextPtr&) const {
    if (hostsCache->has_value()) {
        return std::vector<ShardWithoutRoles> {makeShardWithoutRoles(hostsCache->value(), config.port, config.dbname)};
    } else {
        return make_unexpected(ExplainedError(Error::emptyYcHostsCache));
    }
}

} // namespace sharpei::cloud
