#include <internal/server/bind_handler.h>
#include <internal/server/handlers/ping.h>
#include <internal/server/handlers/stat.h>
#include <internal/cloud/server.h>

namespace sharpei::cloud::server {

void bindHandlers(cache::CachePtr cache) {
    using sharpei::server::bindHandler;
    using sharpei::server::handlers::Ping;
    using sharpei::server::handlers::StatNew;
    using sharpei::server::handlers::tags::Strict;

    bindHandler<Ping>("/ping");
    bindHandler<StatNew<sharpei::reflection::Shard>>("/stat", cache);
    bindHandler<StatNew<sharpei::reflection::Shard>>("/v3/stat", cache);
    bindHandler<StatNew<sharpei::reflection::Shard, Strict>>("/stat/strict", cache);
}

} // namespace sharpei::cloud::server
