#include <internal/config.h>
#include <internal/config_reflection.h>

#include <yamail/data/deserialization/foreign_ptree.h>

#include <stdexcept>

namespace sharpei {

ConfigPtr makeConfig(const yplatform::ptree& data) {
    using yamail::data::deserialization::fromForeignPtree;
    auto config = std::make_shared<Config>(fromForeignPtree<Config>(data));
    if (config->meta.endpointProvider.hostlist.empty()) {
        throw std::logic_error("hostlist should not be empty");
    }
    if (config->meta.endpointProvider.useMetaCacheBasedProviderInMetaPool && !config->metaPoller.enabled) {
        throw std::logic_error("useMetaCacheBasedProviderInMetaPool == true but MetaPoller is disabled");
    }
    return config;
}

}  // namespace sharpei
