#include <mutex>

#include <yplatform/module_registration.h>

#include <internal/datasync/server/server.h>
#include <internal/datasync/module.h>
#include <internal/logger.h>

namespace sharpei {
namespace datasync {

void Module::init(const yplatform::ptree& data) {
    Base::init(data);

    server::bindHandlers(getConfig(),
                         getShardsCache(),
                         getMetaPool(),
                         getShardPool(),
                         getPeersPool(),
                         getMetaAdaptorFactory());

    LOGDOG_(log::GetLogger(log::sharpeiLogKey), notice, log::message="module initialized");
}

} // namespace datasync
} // namespace sharpei

DEFINE_SERVICE_OBJECT(sharpei::datasync::Module)
