#include <internal/server/bind_handler.h>
#include <internal/server/handlers/create_user.h>
#include <internal/datasync/server/handlers/get_user.h>
#include <internal/server/handlers/pingdb.h>
#include <internal/server/handlers/ping.h>
#include <internal/server/handlers/reset.h>
#include <internal/server/handlers/stat.h>
#include <internal/server/handlers/update_user.h>

namespace sharpei {
namespace datasync {
namespace server {

void bindHandlers(ConfigPtr config,
                  cache::CachePtr cache,
                  db::MetaPoolPtr metaPool,
                  db::ShardPoolPtr shardPool,
                  db::PeersPoolPtr peersPool,
                  db::MetaAdaptorFactoryPtr metaAdaptorFactory) {
    using UserIdValue = std::string;

    using sharpei::server::bindHandler;
    using sharpei::server::handlers::Ping;
    using sharpei::server::handlers::Pingdb;
    using sharpei::server::handlers::Reset;
    using sharpei::server::handlers::StatNew;
    using GetUser = handlers::GetUser<UserIdValue>;
    using CreateUser = sharpei::server::handlers::CreateUser<UserIdValue>;
    using UpdateUser = sharpei::server::handlers::UpdateUser<UserIdValue>;

    bindHandler<Ping>("/ping");
    bindHandler<Pingdb>("/pingdb", config, metaPool, metaAdaptorFactory);
    bindHandler<Reset>("/reset_cache", config, cache, metaPool, shardPool, metaAdaptorFactory);
    bindHandler<StatNew<sharpei::reflection::Shard>>("/stat", cache);
    bindHandler<GetUser>("/get_user", config, cache, metaPool, shardPool, metaAdaptorFactory);
    bindHandler<CreateUser>("/create_user", config, cache, metaPool, peersPool, metaAdaptorFactory);
    bindHandler<UpdateUser>("/update_user", config, metaPool, peersPool, metaAdaptorFactory);
}

} // namespace server
} // namespace datasync
} // namespace sharpei
