#include <mail/sharpei/include/internal/db/filtration_strategy.h>

namespace sharpei::db {

bool AcceptingAllNodesFiltrationStrategy::isLagAcceptable(Shard::Database::State::ReplicationLag) const {
    return true;
}

bool AcceptingAllNodesFiltrationStrategy::skipMaster() const {
    return false;
}

// clang-format off
std::vector<Shard::Database> filterDatabases(const Shard::Databases& databases, const IFiltrationStrategy& filter) {
    const auto suitable = [&](const Shard::Database& node) {
        return node.status() == Shard::Database::Status::Alive
        && filter.isLagAcceptable(node.state().lag)
        && (node.role() == Shard::Database::Role::Replica || filter.skipMaster() == false);
    };
    std::vector<Shard::Database> dbs;
    dbs.reserve(databases.size());
    std::copy_if(databases.begin(), databases.end(), std::back_inserter(dbs), suitable);
    return dbs;
}
// clang-format on

} // namespace sharpei::db
