#include <internal/db/pools/thread_connection_pool_map.h>

namespace {

void add(sharpei::db::ApqConnectionPool::Stats& to, const sharpei::db::ApqConnectionPool::Stats& what) {
    to.free_connections += what.free_connections;
    to.busy_connections += what.busy_connections;
    to.pending_connections += what.pending_connections;
    to.max_connections += what.max_connections;
    to.queue_size += what.queue_size;

    to.average_request_roundtrip_usec += what.average_request_roundtrip_usec;
    to.average_request_db_latency_usec += what.average_request_db_latency_usec;
    to.average_wait_time_usec += what.average_wait_time_usec;

    to.num_dropped_connections.timed_out += what.num_dropped_connections.timed_out;
    to.num_dropped_connections.failed += what.num_dropped_connections.failed;
    to.num_dropped_connections.busy += what.num_dropped_connections.busy;
    to.num_dropped_connections.with_result += what.num_dropped_connections.with_result;
}

}  // namespace

namespace sharpei {
namespace db {

ThreadConnectionPoolMap::Stats ThreadConnectionPoolMap::stats() {
    Stats result;
    std::map<ConnectionInfo, unsigned> endpointOccurrences;
    for (auto& pool : pools_) {
        const auto& poolStats = pool.second->stats();
        for (const auto& [endpoint, curPoolEndpointStats] : poolStats) {
            endpointOccurrences[endpoint]++;
            add(result[endpoint], curPoolEndpointStats);
        }
    }

    for (const auto& [endpoint, occurrences] : endpointOccurrences) {
        result[endpoint].average_request_roundtrip_usec /= occurrences;
        result[endpoint].average_request_db_latency_usec /= occurrences;
        result[endpoint].average_wait_time_usec /= occurrences;
    }

    return result;
}

}  // namespace db
}  // namespace sharpei
