#include <mutex>

#include <yplatform/module_registration.h>

#include <internal/disk/server/server.h>
#include <internal/disk/module.h>
#include <internal/logger.h>

namespace sharpei {
namespace disk {

void Module::init(const yplatform::ptree& data) {
    Base::init(data);

    server::bindHandlers(getConfig(),
                         getShardsCache(),
                         getMetaPool(),
                         getShardPool(),
                         getPeersPool(),
                         getMetaAdaptorFactory());

    LOGDOG_(log::GetLogger(log::sharpeiLogKey), notice, log::message="module initialized");
}

} // namespace disk
} // namespace sharpei

DEFINE_SERVICE_OBJECT(sharpei::disk::Module)
