#include <internal/logger.h>
#include <internal/errors.h>

#include <pa/async.h>
#include <yplatform/task_context.h>

#include <boost/uuid/uuid_io.hpp>

#include <algorithm>
#include <random>

namespace {
const std::string statusLogKey{"status"};
}

namespace sharpei {

class PaProfiler: public Profiler {
public:
    PaProfiler(const std::string& sessionId)
        : sessionId_(sessionId)
    {}

    void write(const std::string& operation, std::chrono::milliseconds duration, const std::string& host = "") override {
        pa::async_profiler::add(pa::sharpei, host, operation, sessionId_, uint32_t(duration.count()));
    }
private:
    std::string sessionId_;
};

Scribe::Scribe(ProfilerPtr profiler)
    : Scribe("", "", std::move(profiler))
{}

Scribe::Scribe(const std::string& sessionId, const std::string& requestId)
    : Scribe(sessionId, requestId, std::make_shared<PaProfiler>(sessionId))
{}

Scribe::Scribe(const std::string& sessionId, const std::string& requestId, ProfilerPtr profiler)
    : logger(log::GetLogger(log::sharpeiLogKey, sessionId, requestId)),
      profiler(std::move(profiler)),
      status(log::GetLogger(statusLogKey, sessionId, requestId))
{}

std::string generateUniqId() {
    return yplatform::task_context().uniq_id();
}

std::string generateRequestId(boost::uuids::random_generator& generator) {
    return boost::uuids::to_string(generator());
}

} // namespace sharpei
