#include <internal/mail/config.h>

#include <yamail/data/deserialization/foreign_ptree.h>

YREFLECTION_ADAPT_ADT(sharpei::mail::Config::Registration,
    YREFLECTION_WO_MEMBER_RENAMED(unsigned, get_alive_master_attempts, getAliveMasterAttempts)
    YREFLECTION_WO_MEMBER_RENAMED_WITH_CAST(std::uint64_t, mdb_timeout_ms, std::chrono::milliseconds, mdbTimeout)
    YREFLECTION_WO_MEMBER_RENAMED_WITH_CAST(std::uint64_t, sharddb_timeout_ms, std::chrono::milliseconds, sharddbTimeout)
    YREFLECTION_WO_MEMBER_RENAMED(unsigned, max_commit_tries, maxCommitTries)
    YREFLECTION_WO_MEMBER_RENAMED(unsigned, max_rollback_tries, maxRollbackTries)
    YREFLECTION_WO_MEMBER_RENAMED(unsigned, retry_delay_base_s, retryDelayBase)
    YREFLECTION_WO_MEMBER_RENAMED(bool, enable_welcome_letters, enableWelcomeLetters)
    YREFLECTION_WO_MEMBER_RENAMED(bool, create_base_filters, createBaseFilters)
)


YREFLECTION_ADAPT_ADT(sharpei::mail::Config,
    YREFLECTION_MEMBER(sharpei::mail::Config::Registration, registration)
)

namespace sharpei::mail {

ConfigPtr makeConfig(sharpei::ConfigPtr base, const yplatform::ptree& data) {
    using yamail::data::deserialization::fromForeignPtree;
    const auto result = std::make_shared<Config>(fromForeignPtree<Config>(data));
    result->base_ = std::move(base);
    return result;
}

} // namespace sharpei::mail
