#include <internal/mail/db/adaptors/reg_adaptor.h>
#include <internal/mail/db/register_executor.h>

namespace sharpei {
namespace mail {
namespace db {

class RegAdaptorImpl : public RegAdaptor {
public:
    RegAdaptorImpl(ConfigPtr config, const Scribe& scribe, ShardPoolPtr shardPool, PeersPoolPtr peersPool)
        : config_(config), scribe_(scribe), shardPool_(shardPool), peersPool_(peersPool)
    {}

    void registerUser(const RegParams& params, const Handler& handler) override {
        Profile profile(scribe_.profiler, "registration");
        auto profiled = asyncProfile(std::move(profile), handler);
        auto executor = RegisterUserExecutor<>::create(config_, scribe_, shardPool_, peersPool_, params, profiled);
        executor->execute();
    }

private:
    ConfigPtr config_;
    Scribe scribe_;
    ShardPoolPtr shardPool_;
    PeersPoolPtr peersPool_;
};

RegAdaptorPtr getRegAdaptor(ConfigPtr config, const Scribe& scribe, ShardPoolPtr shardPool, PeersPoolPtr peersPool) {
    return std::make_shared<RegAdaptorImpl>(config, scribe, shardPool, peersPool);
}

} // namespace db
} // namespace mail
} // namespace sharpei
