#include <internal/server/bind_handler.h>
#include <internal/server/handlers/pingdb.h>
#include <internal/server/handlers/ping.h>
#include <internal/server/handlers/reset.h>
#include <internal/server/handlers/stat.h>
#include <internal/server/handlers/sharddb_stat.h>
#include <internal/server/handlers/get_domain.h>
#include <internal/server/handlers/get_organization.h>
#include <internal/mail/server/handlers/get_user.h>
#include <internal/mail/server/server.h>

namespace sharpei {
namespace mail {
namespace server {

void bindHandlers(ConfigPtr config,
                  cache::CachePtr shardsCache,
                  cache::CachePtr metaCache,
                  sharpei::db::MetaPoolPtr metaPool,
                  sharpei::db::ShardPoolPtr shardPool,
                  sharpei::db::PeersPoolPtr peersPool,
                  sharpei::db::MetaAdaptorFactoryPtr metaAdaptorFactory,
                  ::user_journal::ServicePtr userJournalService) {
    using sharpei::server::bindHandler;
    using sharpei::server::handlers::Ping;
    using sharpei::server::handlers::Reset;
    using sharpei::server::handlers::Stat;
    using sharpei::server::handlers::StatNew;
    using sharpei::server::handlers::SharddbStat;
    using sharpei::server::handlers::Pingdb;
    using ConnInfo = handlers::GetUser;
    using DeletedConnInfo = handlers::GetDeletedUser;
    using sharpei::server::handlers::GetDomain;
    using sharpei::server::handlers::GetOrganization;

    const auto getIoContext = [] () -> boost::asio::io_context& {
        return *yplatform::global_net_reactor->io();
    };

    using GetIoContext = std::decay_t<decltype(getIoContext)>;

    bindHandler<Ping>("/ping");
    bindHandler<Reset>("/reset", config->base(), shardsCache, metaPool, shardPool, metaAdaptorFactory);
    bindHandler<Stat>("/stat", shardsCache);
    bindHandler<StatNew<sharpei::reflection::ShardWithStringIdAndPort>>("/v2/stat", shardsCache);
    bindHandler<StatNew<sharpei::reflection::Shard>>("/v3/stat", shardsCache);
    bindHandler<SharddbStat>("/sharddb_stat", metaCache, config->base());
    bindHandler<Pingdb>("/pingdb", config->base(), metaPool, metaAdaptorFactory);
    bindHandler<ConnInfo>("/conninfo",
                          config->base(),
                          shardsCache,
                          metaPool,
                          shardPool,
                          metaAdaptorFactory,
                          ConnInfo::ErrorHandler(config, peersPool, userJournalService));
    bindHandler<DeletedConnInfo>("/deleted_conninfo",
                                 config->base(),
                                 shardsCache,
                                 metaPool,
                                 shardPool,
                                 metaAdaptorFactory,
                                 DeletedConnInfo::ErrorHandler());
    bindHandler<GetDomain<GetIoContext>>("/domain_conninfo",
                                         config->base(),
                                         shardsCache,
                                         metaPool,
                                         peersPool,
                                         metaAdaptorFactory,
                                         getIoContext);
    bindHandler<GetOrganization<GetIoContext>>("/org_conninfo",
                                               config->base(),
                                               shardsCache,
                                               metaPool,
                                               peersPool,
                                               metaAdaptorFactory,
                                               getIoContext);
}

} // namespace server
} // namespace mail
} // namespace sharpei
