#include <internal/mode.h>

namespace sharpei {

inline Mode::Bimap makeBimap(std::initializer_list<Mode::Bimap::value_type> values) {
    return Mode::Bimap(values.begin(), values.end());
}

const Mode::Bimap Mode::map = makeBimap({
    {Mode::Master, "master"},
    {Mode::Replica, "replica"},
    {Mode::WriteOnly, "write_only"},
    {Mode::WriteRead, "write_read"},
    {Mode::ReadWrite, "read_write"},
    {Mode::ReadOnly, "read_only"},
    {Mode::All, "all"}
});

} // namespace sharpei
