#include <internal/poller/meta_shards_provider.h>

#include <internal/config_reflection.h>
#include <yamail/data/reflection/reflection.h>

#include <boost/range/algorithm/transform.hpp>

using namespace sharpei;

namespace {

ShardWithoutRoles::Addresses makeAddresses(const std::vector<db::Host>& hostlist, const std::string& dbname,
                                           unsigned port) {
    using Address = Shard::Database::Address;
    ShardWithoutRoles::Addresses result;
    boost::transform(hostlist, std::inserter(result, result.end()), [&](const auto& elem) {
        const auto dc = std::string(yamail::data::reflection::to_string(elem.dc));
        return Address(elem.host, port, dbname, dc);
    });
    return result;
}

}  // namespace

namespace sharpei::poller {

expected<std::vector<ShardWithoutRoles>> MetaShardsProvider::getAllShards(const TaskContextPtr&) const {
    return std::vector<ShardWithoutRoles>{ShardWithoutRoles(shardId, shardName, makeAddresses(hostlist, dbname, port))};
}

}  // namespace sharpei::poller
