#include <internal/random_shard_id_with_alive_master.h>
#include <internal/random.h>
#include <internal/weighted_random_get.h>

#include <boost/range/algorithm/remove_if.hpp>

namespace sharpei {

std::optional<Shard::Id> getRandomShardIdWithAliveMaster(const cache::Cache& cache,
        db::WeightedShardIds weightedShardIds) {
    const auto hasAliveMaster = [&] (const auto& shard) {
        return static_cast<bool>(cache.getAliveShardMaster(shard.first));
    };
    weightedShardIds.erase(
        boost::range::remove_if(weightedShardIds, std::not_fn(hasAliveMaster)),
        weightedShardIds.end()
    );
    const auto it = getRandomByWeight(weightedShardIds, threadLocalGenerator());
    return it == weightedShardIds.end() ? std::optional<Shard::Id>() : it->first;
}

} // namespace sharpei
