#include <internal/services/iam/json_web_token_file_reader.h>
#include <internal/errors.h>

#include <fstream>

namespace sharpei::services::iam {

JsonWebTokenFileReader::JsonWebTokenFileReader(std::string path)
    : path(std::move(path)) {
}

expected<std::string> JsonWebTokenFileReader::generate(const TaskContextPtr& context) const {
    using namespace std::string_literals;

    LOGDOG_(context->scribe().logger, notice, log::message="read json web token from file: \""s + path + "\"");

    std::ifstream file(path);

    if (!file.is_open()) {
        return make_unexpected(ExplainedError(Error::readJsonWebTokenError, "can't open file \""s + path + "\""));
    }

    std::noskipws(file);

    std::string data {std::istreambuf_iterator<char>(file), std::istreambuf_iterator<char>()};

    if (file.bad() || file.fail()) {
        return make_unexpected(ExplainedError(Error::readJsonWebTokenError, "read \""s + path + "\" error"));
    }

    return {std::move(data)};
}

} // namespace sharpei::services::iam
