#include <internal/shard.h>

namespace sharpei {

Shard::Database::Role::Role(const std::string& str)
    : value(valueFromString(str)) {}

Shard::Database::Role::Value Shard::Database::Role::valueFromString(const std::string& str) {
    if (str == Role(Master).toString()) {
        return Master;
    } else if (str == Role(Replica).toString()) {
        return Shard::Database::Role::Replica;
    } else {
        throw std::logic_error("Shard::Database::Role::valueFromString: '" + str + "' is undefined role");
    }
}

std::string Shard::Database::Role::toString() const {
    switch (value) {
        case Master:
            return "master";
        case Replica:
            return "replica";
    }
    throw std::logic_error("Shard::Database::Role::toString: " + std::to_string(value)
                           + " hasn't string representation");
}

std::string Shard::Database::Status::toString() const {
    switch (value) {
        case Alive:
            return "alive";
        case Dead:
            return "dead";
    }
    throw std::logic_error("Shard::Database::Status::toString: " + std::to_string(value)
                           + " hasn't string representation");
}

} // namespace sharpei
