#include <sstream>

#include <internal/stats.h>

namespace sharpei::stats {

void addMetaPool(const db::MetaPoolPtr& metaPool, yplatform::ptree& ptree) {
    ptree.add_child("meta", makePtree(metaPool->stats()));
}

void addShardPool(const db::ShardPoolPtr& shardPool, yplatform::ptree& ptree) {
    ptree.add_child("shards", makePtree(shardPool->stats()));
}

void addPeersPool(const db::PeersPoolPtr& peersPool, yplatform::ptree& ptree) {
    ptree.add_child("peers", makePtree(peersPool->stats()));
}

yplatform::ptree makePtree(const db::ConnectionPool::Stats& stats) {
    yplatform::ptree result;

    for (const auto& value : stats) {
        const auto& conninfo = value.first;
        std::ostringstream stream;
        stream << conninfo.host() << "_" << conninfo.port() << "_" << conninfo.dbname();
        if (const auto user = conninfo.user()) {
            stream << "_" << user.value();
        }
        result.push_back({stream.str(), makePtree(value.second)});
    }

    return result;
}

yplatform::ptree makePtree(const db::ApqConnectionPool::Stats& stats) {
    yplatform::ptree result;

    result.put("free", stats.free_connections);
    result.put("busy", stats.busy_connections);
    result.put("pending", stats.pending_connections);
    result.put("limit", stats.max_connections);
    result.put("queue_size", stats.queue_size);
    result.put("dropped.busy", stats.num_dropped_connections.busy);
    result.put("dropped.failed", stats.num_dropped_connections.failed);
    result.put("dropped.timed_out", stats.num_dropped_connections.timed_out);
    result.put("dropped.with_result", stats.num_dropped_connections.with_result);
    result.put("average_request_roundtrip_ms", stats.average_request_roundtrip_usec / 1000);
    result.put("average_request_db_latency_ms", stats.average_request_db_latency_usec / 1000);
    result.put("average_wait_time_ms", stats.average_wait_time_usec / 1000);

    return result;
}

} // namespace sharpei::stats
