#include <internal/thread_pool.h>
#include <internal/logger.h>

namespace sharpei {

IoThreadWorker::IoThreadWorker(std::string uniqId, boost::asio::io_context& io)
    : uniqId(std::move(uniqId)),
      io(&io),
      work(boost::asio::make_work_guard(*this->io)),
      thread([this] { serve(); }) {
}

IoThreadWorker::~IoThreadWorker() {
    stop();
    thread.join();
}

void IoThreadWorker::stop() {
    work.reset();
}

void IoThreadWorker::serve() {
    const Scribe scribe(uniqId, "io_thread_worker");

    LOGDOG_(scribe.logger, notice, log::message="io thread worker is started");

    while (true) {
        try {
            io->run();
            break;
        } catch (const std::exception& e) {
            LOGDOG_(scribe.logger, error, log::message="io thread worker unhandled exception", log::exception=e);
        } catch (...) {
            LOGDOG_(scribe.logger, error, log::message="io thread worker unknown unhandled exception");
        }
    }

    LOGDOG_(scribe.logger, notice, log::message="io thread worker is finished");
}

} // namespace sharpei
