LIBRARY()

OWNER(
    g:mail
)

NO_UTIL()

PEERDIR(
    contrib/libs/libpq
    contrib/libs/yajl
    mail/apq
    mail/yreflection
    mail/libblackbox2
    mail/ymod_httpclient
    mail/ymod_webserver
    mail/ymod_statserver
    mail/yplatform/lib
    mail/ymod_webserver_helpers
    mail/user_journal
    mail/mail_errors
    mail/io_result
    mail/ymod_tvm
    mail/butil
    mail/expected
    mail/logdog
)

CFLAGS(
    -DARCADIA_BUILD
)

ADDINCL(
    GLOBAL mail/sharpei/include
    GLOBAL contrib/libs/libpq/src/include
    GLOBAL contrib/libs/libpq/src/interfaces/libpq
)

SRCS(
    db/adaptors/shard_adaptor.cc
    db/adaptors/meta_adaptor.cc
    db/adaptors/request_executor.cc
    db/ep/meta_cache_based_endpoint_provider.cc
    db/pools/thread_connection_pool_map.cc
    db/filtration_strategy.cc
    logger.cc
    disk/server/server.cc
    GLOBAL disk/module.cc
    mail/db/adaptors/reg_adaptor.cc
    mail/registration.cc
    mail/server/server.cc
    GLOBAL mail/module.cc
    mail/config.cc
    mode.cc
    shard.cc
    datasync/server/server.cc
    GLOBAL datasync/module.cc
    module.cc
    config.cc
    cache/state.cc
    cache/cache.cc
    cache/shard_name.cc
    cache/role.cc
    cache/status.cc
    random_shard_id_with_alive_master.cc
    services/blackbox/blackbox_impl.cc
    thread_pool.cc
    stats.cc
    poller/poller.cc
    poller/meta_shards_provider.cc
    cloud/cluster_shards_provider.cc
    cloud/server.cc
    cloud/config.cc
    GLOBAL cloud/module.cc
    services/iam/iam_client.cc
    services/iam/iam_poller.cc
    services/iam/json_web_token_file_reader.cc
    services/yc/yc_client.cc
    services/yc/yc_poller.cc
)

END()
