cimport sharpei_logs_cpp
cimport sharpei_metrics_cpp

cimport mail.unistat.cpp.cython.run_cpp
from mail.unistat.cpp.cython.logs cimport *
from mail.unistat.cpp.cython.meters cimport *

from libcpp.vector cimport vector
from libcpp.memory cimport shared_ptr

from cpython cimport *


cdef class AccessLogRequestCounter:
    cdef shared_ptr[sharpei_metrics_cpp.AccessLogRequestCounter] __impl
    def __cinit__(self, bytes name, bytes endpoint):
        self.__impl.reset(new sharpei_metrics_cpp.AccessLogRequestCounter(<const char*>name, <const char*>endpoint))


cdef class AccessLogTskv:
    cdef shared_ptr[sharpei_logs_cpp.AccessLogTskv] __impl
    def __cinit__(self, pyMeters, cppMeters, bint fastForward, bytes path):
        cdef vector[PyObject *] pm
        for m in pyMeters:
            pm.push_back(<PyObject *>m)
        cdef vector[sharpei_logs_cpp.AccessLogMetrics] am
        for m in cppMeters:
            if isinstance(m, AccessLogCount):
                am.push_back(sharpei_logs_cpp.AccessLogMetrics((<AccessLogCount>m).__impl))
            elif isinstance(m, AccessLogCountByFirstStatusDigit):
                am.push_back(sharpei_logs_cpp.AccessLogMetrics((<AccessLogCountByFirstStatusDigit>m).__impl))
            elif isinstance(m, AccessLogHistogram):
                am.push_back(sharpei_logs_cpp.AccessLogMetrics((<AccessLogHistogram>m).__impl))
            elif isinstance(m, AccessLogHistogramWeak):
                am.push_back(sharpei_logs_cpp.AccessLogMetrics((<AccessLogHistogramWeak>m).__impl))
            elif isinstance(m, AccessLogRequestTimeHist):
                am.push_back(sharpei_logs_cpp.AccessLogMetrics((<AccessLogRequestTimeHist>m).__impl))
            elif isinstance(m, AccessLogRequestCounter):
                am.push_back(sharpei_logs_cpp.AccessLogMetrics((<AccessLogRequestCounter>m).__impl))
            else:
                raise AttributeError("Unknown metric type for AccessLogTskv")
        self.__impl.reset(new sharpei_logs_cpp.AccessLogTskv(pm, am, fastForward, <const char*>path))


cdef class AccessLogHistogram:
    cdef shared_ptr[sharpei_metrics_cpp.AccessLogHistogram] __impl
    def __cinit__(self, vector[long long] buckets, bytes name, bytes endpoint):
        self.__impl.reset(new sharpei_metrics_cpp.AccessLogHistogram(buckets, <const char*>name, <const char*>endpoint))


cdef class AccessLogHistogramWeak:
    cdef shared_ptr[sharpei_metrics_cpp.AccessLogHistogramWeak] __impl
    def __cinit__(self, vector[long long] buckets, bytes name, bytes endpoint):
        self.__impl.reset(new sharpei_metrics_cpp.AccessLogHistogramWeak(buckets, <const char*>name, <const char*>endpoint))


cdef class HttpClientLogRequestCounter:
    cdef shared_ptr[sharpei_metrics_cpp.HttpClientLogRequestCounter] __impl
    def __cinit__(self, bytes name, bytes endpoint):
        self.__impl.reset(new sharpei_metrics_cpp.HttpClientLogRequestCounter(<const char*>name, <const char*>endpoint))


cdef class SharpeiHttpClientLog:
    cdef shared_ptr[sharpei_logs_cpp.SharpeiHttpClientLog] __impl
    def __cinit__(self, pyMeters, cppMeters, bint fastForward, bytes path):
        cdef vector[PyObject *] pm
        for m in pyMeters:
            pm.push_back(<PyObject *>m)
        cdef vector[sharpei_logs_cpp.SharpeiHttpClientLogMetrics] am
        for m in cppMeters:
            if isinstance(m, HttpClientHttpRequestTotalTimeHist):
                am.push_back(sharpei_logs_cpp.SharpeiHttpClientLogMetrics((<HttpClientHttpRequestTotalTimeHist>m).__impl))
            elif isinstance(m, HttpClientLogRequestCounter):
                am.push_back(sharpei_logs_cpp.SharpeiHttpClientLogMetrics((<HttpClientLogRequestCounter>m).__impl))
            else:
                raise AttributeError("Unknown metric type for HTTPClientLog")
        self.__impl.reset(new sharpei_logs_cpp.SharpeiHttpClientLog(pm, am, fastForward, <const char*>path))


cdef class SharpeiLog:
    cdef shared_ptr[sharpei_logs_cpp.SharpeiLog] __impl
    def __cinit__(self, pyMeters, cppMeters, bint fastForward, bytes path):
        cdef vector[PyObject *] pm
        for m in pyMeters:
            pm.push_back(<PyObject *>m)
        cdef vector[sharpei_logs_cpp.SharpeiLogMetrics] cm
        for m in cppMeters:
            if isinstance(m, CountErrors):
                cm.push_back(sharpei_logs_cpp.SharpeiLogMetrics((<CountErrors>m).__impl))
            else:
                raise AttributeError("Unknown metric type for SharpeiLog")
        self.__impl.reset(new sharpei_logs_cpp.SharpeiLog(pm, cm, fastForward, <const char*>path))


cdef class PaLogHistogram:
    cdef shared_ptr[sharpei_metrics_cpp.PaLogHistogram] __impl
    def __cinit__(self, vector[long long] buckets, bytes request, bytes prefix):
        self.__impl.reset(new sharpei_metrics_cpp.PaLogHistogram(buckets, <const char*>request, <const char*>prefix))


cdef class PaLogHistogramForEndpoint:
    cdef shared_ptr[sharpei_metrics_cpp.PaLogHistogramForEndpoint] __impl
    def __cinit__(self, vector[long long] buckets, bytes request, bytes prefix, bytes endpoint):
        self.__impl.reset(new sharpei_metrics_cpp.PaLogHistogramForEndpoint(buckets, <const char*>request, <const char*>prefix, <const char*>endpoint))


cdef class SharpeiPaLog:
    cdef shared_ptr[sharpei_logs_cpp.SharpeiPaLog] __impl
    def __cinit__(self, pyMeters, cppMeters, bint fastForward, bytes path):
        cdef vector[PyObject *] pm
        for m in pyMeters:
            pm.push_back(<PyObject *>m)
        cdef vector[sharpei_logs_cpp.SharpeiPaLogMetrics] cm
        for m in cppMeters:
            if isinstance(m, PaLogHistogram):
                cm.push_back(sharpei_logs_cpp.SharpeiPaLogMetrics((<PaLogHistogram>m).__impl))
            elif isinstance(m, PaLogHistogramForEndpoint):
                cm.push_back(sharpei_logs_cpp.SharpeiPaLogMetrics((<PaLogHistogramForEndpoint>m).__impl))
            else:
                raise AttributeError("Unknown metric type for SharpeiPaLog")
        self.__impl.reset(new sharpei_logs_cpp.SharpeiPaLog(pm, cm, fastForward, <const char*>path))


cdef class StatusCounter:
    cdef shared_ptr[sharpei_metrics_cpp.StatusCounter] __impl
    def __cinit__(self, bytes namePrefix, bytes shard, bytes host, bool alive):
        self.__impl.reset(new sharpei_metrics_cpp.StatusCounter(<const char*>namePrefix, <const char*>shard, <const char*>host, alive))


cdef class StatusLog:
    cdef shared_ptr[sharpei_logs_cpp.StatusLog] __impl
    def __cinit__(self, pyMeters, cppMeters, bint fastForward, bytes path):
        cdef vector[PyObject *] pm
        for m in pyMeters:
            pm.push_back(<PyObject *>m)
        cdef vector[sharpei_logs_cpp.StatusLogMetrics] cm
        for m in cppMeters:
            if isinstance(m, StatusCounter):
                cm.push_back(sharpei_logs_cpp.StatusLogMetrics((<StatusCounter>m).__impl))
            else:
                raise AttributeError("Unknown metric type for StatusLog")
        self.__impl.reset(new sharpei_logs_cpp.StatusLog(pm, cm, fastForward, <const char*>path))


def run(host, port, pyLogs, yplatformLogPath, logLevel):
    cdef vector[logs_cpp.Logs] cppLogs
    for l in pyLogs:
        if isinstance(l, AccessLogTskv):
            cppLogs.push_back(
                logs_cpp.Logs((<AccessLogTskv>l).__impl)
            )
        elif isinstance(l, SharpeiLog):
            cppLogs.push_back(
                logs_cpp.Logs((<SharpeiLog>l).__impl)
            )
        elif isinstance(l, SharpeiHttpClientLog):
            cppLogs.push_back(
                logs_cpp.Logs((<SharpeiHttpClientLog>l).__impl)
            )
        elif isinstance(l, SharpeiPaLog):
            cppLogs.push_back(
                logs_cpp.Logs((<SharpeiPaLog>l).__impl)
            )
        elif isinstance(l, StatusLog):
            cppLogs.push_back(
                logs_cpp.Logs((<StatusLog>l).__impl)
            )
        else:
            raise AttributeError("Unknown log type")
    mail.unistat.cpp.cython.run_cpp.run(host, port, cppLogs, yplatformLogPath, logLevel)
