#pragma once

#include "sharpei_metrics.h"

#include <mail/unistat/cpp/include/common_logs.h>

namespace unistat {

using SharpeiLogMetrics = std::variant<std::shared_ptr<CountErrors>>;

using SharpeiLog = Log<TextFileReader, File, TskvParser, SharpeiLogMetrics>;
using SharpeiLogPtr = std::shared_ptr<SharpeiLog>;

using AccessLogMetrics =
    std::variant<std::shared_ptr<AccessLogCount>, std::shared_ptr<AccessLogRequestCounter>,
                 std::shared_ptr<AccessLogCountByFirstStatusDigit>, std::shared_ptr<AccessLogRequestTimeHist>,
                 std::shared_ptr<AccessLogHistogram>, std::shared_ptr<AccessLogHistogramWeak>>;
using AccessLogTskv = Log<TextFileReader, File, TskvParser, AccessLogMetrics>;
using AccessLogTskvPtr = std::shared_ptr<AccessLogTskv>;

using SharpeiHttpClientLogMetrics =
    std::variant<std::shared_ptr<HttpClientHttpRequestTotalTimeHist>, std::shared_ptr<HttpClientLogRequestCounter>>;
using SharpeiHttpClientLog = Log<TextFileReader, File, TskvParser, SharpeiHttpClientLogMetrics>;
using SharpeiHttpClientLogPtr = std::shared_ptr<SharpeiHttpClientLog>;

using SharpeiPaLogMetrics = std::variant<std::shared_ptr<PaLogHistogram>, std::shared_ptr<PaLogHistogramForEndpoint>>;
using SharpeiPaLog = Log<PaReader, File, PaParser, SharpeiPaLogMetrics>;
using SharpeiPaLogPtr = std::shared_ptr<SharpeiPaLog>;

using StatusLogMetrics = std::variant<std::shared_ptr<StatusCounter>>;
using StatusLog = Log<TextFileReader, File, TskvParser, StatusLogMetrics>;
using StatusLogPtr = std::shared_ptr<StatusLog>;

using Logs = std::variant<AccessLogTskvPtr, SharpeiLogPtr, SharpeiHttpClientLogPtr, SharpeiPaLogPtr, StatusLogPtr>;

}  // namespace unistat
