#include <mail/sharpei/unistat/cpp/sharpei_metrics.h>

#include <chrono>
#include <string>
#include <string_view>

namespace unistat {

std::optional<std::chrono::milliseconds> YmodWebserverAccessLogAdaptor::getExecTime(
    const std::map<std::string, std::string>& record) {
    if (auto time = record.find("profiler_exec"); time != record.end()) {
        using namespace std::chrono;
        return {duration_cast<milliseconds>(duration<double>(std::stod(time->second)))};
    }
    return std::nullopt;
}

std::optional<std::string_view> YmodWebserverAccessLogAdaptor::getRequest(
    const std::map<std::string, std::string>& record) {
    if (auto req = record.find("request"); req != record.end()) {
        return {req->second};
    }
    return std::nullopt;
}

std::optional<long> YmodWebserverAccessLogAdaptor::getStatus(const std::map<std::string, std::string>& record) {
    if (auto st = record.find("status_code"); st != record.end()) {
        return {std::stol(st->second)};
    }
    return std::nullopt;
}

std::optional<std::string_view> HttpClientLogAdaptor::getRequest(const std::map<std::string, std::string>& record) {
    if (auto req = record.find("uri"); req != record.end()) {
        return {req->second};
    }
    return std::nullopt;
}

std::optional<long> HttpClientLogAdaptor::getStatus(const std::map<std::string, std::string>& record) {
    if (auto st = record.find("status"); st != record.end()) {
        return {std::stol(st->second)};
    }
    return std::nullopt;
}

std::optional<std::string_view> PaLogAdaptor::getRequest(const PaRecord& record) {
    static constexpr size_t maxLength = std::size(decltype(PaRecord::req){});
    return {std::string_view{record.req, strnlen(record.req, maxLength)}};
}

std::optional<std::chrono::milliseconds> PaLogAdaptor::getExecTime(const PaRecord& record) {
    return {std::chrono::milliseconds(record.spent_ms)};
}

std::optional<std::string_view> PaLogAdaptor::getEndpoint(const PaRecord& record) {
    static constexpr size_t maxLength = std::size(decltype(PaRecord::host){});
    return {std::string_view{record.host, strnlen(record.host, maxLength)}};
}

std::optional<std::string_view> StatusLogAdaptor::getHost(const std::map<std::string, std::string>& record) {
    if (auto host = record.find("host"); host != record.end()) {
        return {host->second};
    }
    return std::nullopt;
}

std::optional<std::string_view> StatusLogAdaptor::getState(const std::map<std::string, std::string>& record) {
    if (auto state = record.find("smooth_state"); state != record.end()) {
        return {state->second};
    }
    return std::nullopt;
}

std::optional<std::string_view> StatusLogAdaptor::getShardName(const std::map<std::string, std::string>& record) {
    if (auto shardName = record.find("shard_name"); shardName != record.end()) {
        return {shardName->second};
    }
    return std::nullopt;
}

std::optional<StatusLogAdaptor::Unixtime> StatusLogAdaptor::getUnixtime(
    const std::map<std::string, std::string>& record) {
    if (auto unixtime = record.find("unixtime"); unixtime != record.end()) {
        return {std::stoull(unixtime->second)};
    }
    return std::nullopt;
}

}  // namespace unistat
