#ifndef SHARPEI_CLIENT_HTTP_H
#define SHARPEI_CLIENT_HTTP_H

#include <memory>
#include <map>
#include <vector>
#include <functional>
#include <chrono>
#include <sharpei_client/errors.h>

namespace sharpei {
namespace client {
namespace http {


struct ClientSettings {
    std::string clusterClientModuleName;
};

typedef std::map<std::string, std::vector<std::string> > Arguments;
typedef std::map<std::string, std::vector<std::string> > Headers;

struct Address {
    std::string host;
    unsigned port = 0;

    bool operator==(const Address& other) const {
        return host == other.host && port == other.port;
    }
};

typedef std::chrono::milliseconds Timeout;

struct Response {
    unsigned code;
    std::string body;
};

typedef std::function<void(boost::system::error_code error, const Response&)> ResponseHandler;

class HttpClient {
public:
    virtual ~HttpClient() {}

    virtual void aget(const Address& addr,
        Timeout timeout,
        const std::string& method,
        const Arguments& args,
        const Headers& headers,
        ResponseHandler handler,
        bool keepAlive,
        const std::string& requestId) const = 0;

    virtual void apost(const Address& addr,
        Timeout timeout,
        const std::string& method,
        const Arguments& args,
        const Headers& headers,
        const std::string& data,
        ResponseHandler handler,
        bool keepAlive,
        const std::string& requestId) const = 0;
};

typedef std::shared_ptr<const HttpClient> HttpClientPtr;

} // namespace
} // namespace
} // namespace

#endif // SHARPEI_CLIENT_HTTP_H
