#include <sharpei_client/integration.h>

#include <yamail/data/reflection/reflection.h>
#include <yamail/data/deserialization/ptree.h>

namespace {

bool toBool(const std::string& value) {
    if (value == "1" || value == "t" || value == "yes" || value == "true") {
        return true;
    } else if (value == "0" || value == "f" || value == "no" || value == "false") {
        return false;
    }
    throw std::runtime_error("invalid bool value: " + value);
}

} // namespace

YREFLECTION_ADAPT_ADT(sharpei::client::http::ClientSettings,
    YREFLECTION_WO_MEMBER_RENAMED(std::string, cluster_client_module, clusterClientModuleName)
)

YREFLECTION_ADAPT_ADT(sharpei::client::Settings,
    YREFLECTION_WO_MEMBER_RENAMED(std::string, host, sharpeiAddress.host)
    YREFLECTION_WO_MEMBER_RENAMED(unsigned, port, sharpeiAddress.port)
    YREFLECTION_WO_MEMBER(unsigned, retries)
    YREFLECTION_WO_MEMBER_RENAMED_WITH_CAST(std::uint64_t, timeout_ms, std::chrono::milliseconds, timeout)
    YREFLECTION_WO_MEMBER_RENAMED_WITH_CAST(std::string, keep_alive, toBool, keepAlive)
    YREFLECTION_WO_MEMBER_RENAMED(std::optional<sharpei::client::http::ClientSettings>, http_client, httpClient)
)

namespace sharpei {
namespace client {
namespace integration {

using Milliseconds = std::chrono::milliseconds;

Settings parseSharpeiSettings(const ptree& sharpeiTree,
        Settings::HttpExceptionHandler onHttpExc,
        Settings::HttpErrorHandler onHttpErr) {
    using yamail::data::deserialization::fromPtree;
    try {
        Settings s;
        if (auto httpClientTree = sharpeiTree.get_child_optional("http_client"); httpClientTree)
        {
            s.httpClient = fromPtree<http::ClientSettings>(*httpClientTree);
        }
        else {
            s = fromPtree<Settings>(sharpeiTree);
        }

        if( onHttpExc ) {
            s.onHttpException = std::move(onHttpExc);
        }
        if( onHttpErr ) {
            s.onHttpError = std::move(onHttpErr);
        }
        return s;
    } catch (const std::exception& e) {
        throw std::runtime_error("failed to init sharpei settings: " + std::string(e.what()));
    }
}

} // namespace integration
} // namespace client
} // namespace sharpei


