package main

import (
	"fmt"
	"net/http"
	"strings"
)

var (
	cards = make(map[string]string)
	vcard = []string{
		"BEGIN:VCARD",
		"VERSION:3.0",
		"EMAIL;TYPE=WORK:%[1]s@yandex-team.ru",
		"X-JABBER;TYPE=WORK:%[1]s@yandex-team.ru",
		"TEL;TYPE=cell,voice,msg,pref:123",
		"BDAY:20200202",
		"TEL;TYPE=WORK:123",
		"X-ANNIVERSARY:20000101",
		"X-EVOLUTION-ANNIVERSARY:20000101",
		"EMAIL;TYPE=HOME:%[1]s@ya.ru",
		"X-JABBER;TYPE=HOME:%[1]s@ya.ru",
		"TZ:Europe/Moscow",
		"END:VCARD",
	}
	jcard = []string{
		`{"1": {"tzs": ["Europe/Moscow"],`,
		`"emails": [{"type": ["WORK"], "email": "%[1]s@yandex-team.ru"}, {"type": ["HOME"], "email": "%[1]s@ya.ru"}],`,
		`"instant_messengers": [{"service_type": "ICQ", "service_id": "icq1"}, {"service_type": "ICQ", "service_id": "icq2"}, {"service_type": "skype", "service_id": "skype"}],`,
		`"social_profiles": [{"profile": "twitter1", "type": ["twitter"]}, {"profile": "twitter2", "type": ["twitter"]}, {"profile": "%[1]s@yandex-team.ru", "type": ["jabber", "WORK"]}, {"profile": "%[1]s@ya.ru", "type": ["jabber", "HOME"]}],`,
		`"names": [{"middle": "", "prefix": "", "last": "abc", "suffix": "", "first": "def"}],`,
		`"telephone_numbers": [{"type": ["cell"], "telephone_number": "123"}, {"type": ["home"], "telephone_number": "456"}, {"type": ["WORK"], "telephone_number": "789"}],`,
		`"events": [{"month": "01", "type": ["bday"], "day": "01", "year": "2000"}, {"month": "01", "type": ["x-anniversary"], "day": "01", "year": "2000"}, {"month": "01", "type": ["x-evolution-anniversary"], "day": "01", "year": "2000"}]}}`,
	}
)

func (g *Gun) makeReq(payload *Payload) *http.Request {
	req, _ := http.NewRequest(payload.Method, strings.Join([]string{"http://", g.conf.Target, payload.URI}, ""), strings.NewReader(payload.Data))
	req.Header.Add("Content-Type", payload.Cotype)
	req.Header.Add("X-Real-IP", "213.180.206.57")
	req.Header.Add("User-Agent", "pandora")
	fmt.Println(payload.Data)
	return req
}

func (g *Gun) genPayload(ammo *Ammo) *Payload {
	payload := Payload{
		Method: "POST",
		Assert: "error",
		Data:   "",
		Cotype: "application/text",
	}
	switch ammo.Tag {
	case "from_vcard":
		payload.URI = "/v1/from_vcard?uid=" + ammo.UID
		payload.Data = fmt.Sprintf(cards["vcard"], ammo.UID)
	case "to_vcard":
		payload.URI = "/v1/to_vcard?uid=" + ammo.UID
		payload.Data = fmt.Sprintf(cards["jcard"], ammo.UID)
		payload.Cotype = "application/json"
	case "colabook_export":
		payload.Method = "GET"
		payload.URI = "/compat/colabook_export?&tp=vcard3&lang=ru&mode=primary&full=yes&uid=" + ammo.UID
	case "colabook_import":
		payload.URI = "/compat/colabook_import.json?uid=" + ammo.UID
		payload.Data = fmt.Sprintf(cards["vcard"], ammo.UID)
	default:
		payload.Method = "GET"
		payload.URI = "/ping"
		payload.Assert = ""
	}
	return &payload
}
