import random
import json
import argparse


def weighted_json_choice(choices):
    '''dict where key is choice and value probability'''
    total = sum(choices[choice] for choice in choices)
    r = random.uniform(0, total)
    upto = 0
    for choice in choices:
        if upto + choices[choice] >= r:
            return choice
        upto += choices[choice]


class Ammo(object):
    def __init__(self, source, profile):
        self.source = source
        self.tags = self.set_distr_from_json(profile)
        

    def set_distr_from_json(self, input_json):
        profile = json.loads(input_json.replace(" ", "").replace("\n", ""))
        out = []
        for i in xrange(400000):
            out.append(weighted_json_choice(profile))
        return out


    def make_ammo(self):
        i = 0
        uids = []
        with open(self.source, "r") as src:
            for line in src:
                uids.append(line.replace("\n", "").replace(" ", ""))
        count = len(uids) 
        if count > 0:
            with open("ammo.json", "w") as ammo:
                for  tag in self.tags:
                    line = '{"tag": "%s", "uid": "%s"}\n' % (str(tag), uids[i%count])
                    ammo.write(line)


if __name__ == "__main__":

    parser = argparse.ArgumentParser()
    parser.add_argument("--src", type=str, help="datasource", default='uids.csv')
    parser.add_argument("--profile", type=str, help="string with json profile, in handler:weight format", default='{"to_vcard": 1250, "from_vcard": 25, "colabook_export": 2, "colabook_import": 1}')
    args = parser.parse_args()

    SOURCE = args.src
    PROFILE = args.profile

    ammo = Ammo(SOURCE, PROFILE)
    ammo.make_ammo()
