#!/bin/bash
#
# Provides: sheltie_4xx

set -eo pipefail

while getopts ":l:" opt; do
    case $opt in
        l)
            LIMIT="$OPTARG" >&2
            ;;
        \?)
            echo "invalid option: -$OPTARG" >&2
            ;;
    esac
done

if [[ $# -ne 2 ]] ; then
    echo "wrong number of args"
    exit 1
fi

sheltie_4xx=$(timetail -t tskv -n60 /app/log/access.tskv | grep -c -P "\tstatus_code=4[0-9]{1}[0-8]{1}")

if [[ "$sheltie_4xx" -gt "$LIMIT" ]]; then
    echo "PASSIVE-CHECK:sheltie_4xx;2;4xx: $sheltie_4xx"
else
    echo "PASSIVE-CHECK:sheltie_4xx;0;4xx: $sheltie_4xx"
fi

