#!/bin/bash
#
# Provides: sheltie_5xx

set -eo pipefail

while getopts ":l:" opt; do
    case $opt in
        l)
            LIMIT="$OPTARG" >&2
            ;;
        \?)
            echo "invalid option: -$OPTARG" >&2
            ;;
    esac
done

if [[ $# -ne 2 ]] ; then
    echo "wrong number of args"
    exit 1
fi

sheltie_5xx=$(timetail -t tskv -n60 /app/log/access.tskv | grep -c -P "\tstatus_code=5[0-9]{2}")

if [[ "$sheltie_5xx" -gt "$LIMIT" ]]; then
    echo "PASSIVE-CHECK:sheltie_5xx;2;5xx: $sheltie_5xx"
else
    echo "PASSIVE-CHECK:sheltie_5xx;0;5xx: $sheltie_5xx"
fi

