#!/bin/bash
#
# Provides: sheltie_nginx_4xx

set -eo pipefail

sheltie_nginx_4xx=$(timetail -t tskv -n60 /var/log/nginx/sheltie/access.tskv | grep -c -P "\tstatus=4[0-9]{1}[0-8]{1}")

if [ $sheltie_nginx_4xx -gt 10 ]; then
    echo "PASSIVE-CHECK:sheltie_nginx_4xx;2;4xx: $sheltie_nginx_4xx"
else
    echo "PASSIVE-CHECK:sheltie_nginx_4xx;0;4xx: $sheltie_nginx_4xx"
fi

